import machine
import utime
from neopixel import Neopixel

uart = machine.UART(1, baudrate=115200, tx=machine.Pin(4), rx=machine.Pin(5))
num_pixels = 4
pixels = Neopixel(num_pixels, 0, 20, "GRB")
RED = (150, 0, 0)
GREEN = (0, 150, 0)
BLUE = (0, 0, 150)
WHITE = (150, 150, 150)
BLACK = (0, 0, 0)

if __name__ == '__main__':
    while True:
        if uart.any() == True:
            cmd = uart.read(1)
            print(cmd)
            if cmd == b'1':
                pixels.fill(BLACK)
                pixels.set_pixel(0,WHITE)  
                pixels.show()
            if cmd == b'2':
                pixels.fill(BLACK)
                pixels.set_pixel(1,WHITE)  
                pixels.show()
            if cmd == b'3':
                pixels.fill(BLACK)
                pixels.set_pixel(2,WHITE)  
                pixels.show()
            if cmd == b'4':
                pixels.fill(BLACK)
                pixels.set_pixel(3,WHITE)  
                pixels.show()
            if cmd == b'5':
                pixels.fill(RED)
                pixels.show()
            if cmd == b'6':
                pixels.fill(GREEN)
                pixels.show()
            if cmd == b'7':
                pixels.fill(BLUE)
                pixels.show()
            if cmd == b'8':
                pixels.fill(WHITE)
                pixels.show()
            if cmd == b'9':
                pixels.fill(BLACK)
                pixels.show()
        utime.sleep(0.1)
